#!/bin/bash

# ============================================
# Start Script for WhatsApp Business Scraper
# Auto-restart on crash
# ============================================

echo "🚀 Starting WhatsApp Business Scraper..."

# Create logs directory if doesn't exist
mkdir -p logs

# Kill any existing process
echo "📴 Stopping existing processes..."
pkill -f "node server.js" 2>/dev/null

# Wait a moment
sleep 2

# Start server with nohup
echo "▶️  Starting server..."
nohup node server.js > logs/app.log 2>&1 &

# Get process ID
PID=$!

echo "✅ Server started with PID: $PID"
echo "📊 View logs: tail -f logs/app.log"
echo "🛑 Stop server: kill -9 $PID"

# Wait and check if started successfully
sleep 3

if ps -p $PID > /dev/null; then
    echo "✅ Server is running!"
    
    # Try health check
    sleep 2
    if command -v curl &> /dev/null; then
        echo "🏥 Health check:"
        curl -s http://localhost:8080/health | head -n 1
    fi
else
    echo "❌ Server failed to start. Check logs/app.log"
    tail logs/app.log
fi
