"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.layout = void 0;
const prefixSpace = function (str) {
    const matched = /^\s+/gu.exec(str);
    return matched ? matched[0].length : 0;
};
const tailSpace = function (str) {
    const matched = /\s+$/gu.exec(str);
    return matched ? matched[0].length : 0;
};
const calcIndent = function (lines, charLines) {
    let maxPossible = Infinity;
    for (let i = 1; i < lines.length; i++) {
        const formerTailNum = tailSpace(lines[i]);
        const latterPrefixNum = prefixSpace(charLines[i]);
        maxPossible = Math.min(maxPossible, formerTailNum + latterPrefixNum);
    }
    return maxPossible;
};
const appendCharacter = function (lines, charLines, spacing) {
    const indent = calcIndent(lines, charLines);
    return lines.map((l, i) => {
        const allowIndent = tailSpace(l);
        const charPrefixSpace = prefixSpace(charLines[i]);
        const spaceNeedRetain = allowIndent + charPrefixSpace - indent + spacing;
        return l.replace(/\s+$/gu, '') + ' '.repeat(spaceNeedRetain) + charLines[i].replace(/^\s+/gu, '');
    });
};
const layout = function (str, dictionary, opt) {
    const { spacing, maxLineWidth } = opt;
    const charSet = str.split('');
    const linesSet = charSet.filter(c => dictionary[c.toLowerCase()]).map(c => dictionary[c.toLowerCase()].lines);
    const prints = [[...linesSet[0]]];
    for (let i = 1; i < linesSet.length; i++) {
        if (prints[prints.length - 1][0].length <= maxLineWidth) {
            prints[prints.length - 1] = appendCharacter(prints[prints.length - 1], linesSet[i], spacing);
        }
        else {
            prints.push(linesSet[i]);
        }
    }
    return prints.reduce((prev, i) => [...prev, ...i], []);
};
exports.layout = layout;
