"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.yo = void 0;
const chalk_1 = __importDefault(require("chalk"));
const load_1 = require("./load");
const typesetting_1 = require("./typesetting");
const const_1 = require("./const");
const debug_1 = require("./debug");
const PALETTE = ['red', 'green', 'yellow', 'blue', 'magenta', 'cyan', 'white'];
const formatOption = function (opt) {
    var _a, _b, _c, _d, _e, _f;
    let paddingStart = (_a = opt === null || opt === void 0 ? void 0 : opt.paddingStart) !== null && _a !== void 0 ? _a : const_1.DEFAULT_PADDING_START;
    if (paddingStart < 0) {
        paddingStart = 0;
    }
    const fontFamily = (_b = opt === null || opt === void 0 ? void 0 : opt.fontFamily) !== null && _b !== void 0 ? _b : 'default';
    const spacing = (_c = opt === null || opt === void 0 ? void 0 : opt.spacing) !== null && _c !== void 0 ? _c : const_1.DEFAULT_SPACING;
    const maxLineWidth = (_d = opt === null || opt === void 0 ? void 0 : opt.maxLineWidth) !== null && _d !== void 0 ? _d : const_1.DEFAULT_MAX_LINE_WIDTH;
    const silent = (_e = opt === null || opt === void 0 ? void 0 : opt.silent) !== null && _e !== void 0 ? _e : const_1.DEFAULT_SILENT;
    const color = (opt === null || opt === void 0 ? void 0 : opt.color) === 'random' ? PALETTE[Math.floor(Math.random() * PALETTE.length)] : (_f = opt === null || opt === void 0 ? void 0 : opt.color) !== null && _f !== void 0 ? _f : const_1.DEFAULT_COLOR;
    return {
        fontFamily,
        color,
        spacing,
        paddingStart,
        silent,
        maxLineWidth,
    };
};
const dictionaryMap = {};
const yo = function (str, opt) {
    const options = formatOption(opt);
    debug_1.debug('options:', options);
    const fontName = options.fontFamily === 'default' ? 'default' : options.fontFamily.name;
    if (!dictionaryMap[fontName]) {
        dictionaryMap[fontName] = {};
    }
    if (!Object.keys(dictionaryMap[fontName]).length) {
        debug_1.debug(`load font ${fontName}`);
        dictionaryMap[fontName] = options.fontFamily === 'default' ? load_1.load() : load_1.load(options.fontFamily);
    }
    const dictionary = dictionaryMap[fontName];
    const lines = typesetting_1.layout(str, dictionary, options).map(l => `${' '.repeat(options.paddingStart)}${l}`);
    if (!options.silent) {
        if (options.color === 'rainbow') {
            throw Error('Not support rainbow color in this env. Are you using it in the non-nodejs environment?');
        }
        let paint = (s) => s;
        const color = options.color === 'random' ? PALETTE[Math.floor(Math.random() * PALETTE.length)] : options.color;
        if (typeof chalk_1.default[color] === 'function') {
            paint = (s) => chalk_1.default[color](s);
        }
        lines.forEach(l => {
            console.log(paint(l));
        });
    }
    return lines;
};
exports.yo = yo;
