# تعليمات التثبيت على سيرفر VPS (Ubuntu/Debian)

لقد قمت بإعداد ملف `setup_vps.sh` لتسهيل العملية. يرجى اتباع الخطوات التالية بدقة لتجنب مشاكل "البيانات الوهمية" و "فشل QR".

## 1. رفع الملفات
- قم بضغط ملفات المشروع (بدون مجلد `node_modules` ومجلد `tokens`) وارفعها إلى السيرفر.
- فك الضغط في مجلد، مثلاً `/var/www/vc`.

## 2. إعداد التثبيت (مهم جداً للـ QR)
قم بتشغيل السكريبت المرفق لتثبيت Node.js ومتصفح Chrome (حل مشكلة Windows Format + QR):

```bash
sed -i 's/\r$//' setup_vps.sh
chmod +x setup_vps.sh
./setup_vps.sh
```

## 3. إعداد مفاتيح API (مهم جداً للبحث)
مشكلة "البيانات الوهمية" تحدث لأن السيرفر لا يملك مفاتيح جوجل.
قم بإنشاء ملف `.env` في نفس المجلد:

```bash
nano .env
```

وضع بداخله المحتوى التالي (استبدل القيم بمفاتيحك الحقيقية):

```env
PORT=8080
GOOGLE_MAPS_API_KEY=ضع_مفتاح_جوجل_هنا
WHATSAPP_TOKEN=ضع_توكن_واتساب_هنا
WHATSAPP_PHONE_NUMBER_ID=ضع_معرف_رقم_الهاتف_هنا
```

*ملاحظة: تأكد من تفعيل "Places API" في كونسول جوجل لهذا المفتاح.*

## 4. تشغيل التطبيق
استخدم PM2 لضمان عمل التطبيق في الخلفية:

```bash
pm2 start server.js --name "whatsapp-bot"
pm2 save
pm2 startup
```

## حل المشاكل الشائعة

### مشكلة: ظهور بيانات وهمية فقط
- **السبب**: مفتاح `GOOGLE_MAPS_API_KEY` غير موجود في ملف `.env` أو غير صالح.
- **الحل**: تأكد من الخطوة رقم 3.

### مشكلة: QR Failed / فشل ربط الواتساب
- **السبب**: متصفح Chrome غير مثبت على السيرفر.
- **الحل**: تأكد من تنفيذ الخطوة رقم 2 بنجاح.
