# حل مشكلة البيانات الوهمية باستخدام وسيط PHP

## المشكلة
تم تحديد أن التطبيق يعرض بيانات وهمية بعد رفعه على cPanel في بيئة AlmaLinux 8، وذلك لعدم وجود دعم لـ Node.js في هذه البيئة.

## الحل
قمنا بإنشاء حل بديل باستخدام PHP كوسيط للاتصال بـ Google Maps API، حيث أن PHP متوفر افتراضياً في معظم خوادم cPanel.

## الملفات التي تم إنشاؤها أو تعديلها

1. **ملف api-proxy.php (جديد)**:
   - وسيط PHP للاتصال بـ Google Maps API
   - يقوم بمعالجة طلبات البحث وإرجاع النتائج بتنسيق JSON

2. **تعديل ملف config.js**:
   - إضافة خيار `usePhpProxy: true` لاستخدام وسيط PHP
   - إضافة `phpProxyUrl: "/api-proxy.php"` لتحديد مسار وسيط PHP
   - تعطيل `useProxy` و `useDirectApi` لتجنب استخدام Node.js

3. **تعديل ملف app.js**:
   - إضافة منطق جديد للاتصال بوسيط PHP عندما يكون `usePhpProxy` مفعلاً
   - الاحتفاظ بالمنطق القديم للتوافق مع الإصدارات السابقة

## خطوات التثبيت على cPanel

1. **رفع الملفات إلى cPanel**:
   - قم بتسجيل الدخول إلى حساب cPanel الخاص بك
   - انتقل إلى مدير الملفات (File Manager)
   - انتقل إلى المجلد الذي تريد تثبيت التطبيق فيه (مثل `public_html`)
   - ارفع جميع ملفات المشروع، بما في ذلك الملفات المعدلة والجديدة

2. **التأكد من صلاحيات الملفات**:
   - تأكد من أن ملف `api-proxy.php` له صلاحيات تنفيذ (644 أو 755)
   - يمكنك ضبط الصلاحيات من خلال النقر بزر الماوس الأيمن على الملف واختيار "Change Permissions"

3. **اختبار التطبيق**:
   - افتح متصفح الويب وانتقل إلى موقعك `66.techprocode.com`
   - قم بإجراء بحث للتأكد من أن التطبيق يعرض بيانات حقيقية الآن

## استكشاف الأخطاء وإصلاحها

إذا استمرت المشكلة، جرب ما يلي:

1. **التحقق من سجلات الخطأ**:
   - من لوحة تحكم cPanel، انتقل إلى قسم "Error Log"
   - ابحث عن أي رسائل خطأ متعلقة بملف `api-proxy.php`

2. **اختبار وسيط PHP مباشرة**:
   - افتح متصفح الويب وانتقل إلى `https://66.techprocode.com/api-proxy.php?keyword=restaurants&location=dubai&resultCount=5`
   - تحقق من النتائج للتأكد من أن وسيط PHP يعمل بشكل صحيح

3. **التحقق من إعدادات PHP**:
   - تأكد من تفعيل وظيفة `file_get_contents` في إعدادات PHP
   - إذا كانت معطلة، يمكنك استخدام cURL بدلاً منها (قم بالتواصل معي للحصول على نسخة معدلة من الكود)

4. **تعديل مسار وسيط PHP**:
   - إذا كان التطبيق في مجلد فرعي، قد تحتاج إلى تعديل `phpProxyUrl` في ملف `config.js` ليكون مسارًا مطلقًا بدلاً من مسار نسبي

## ملاحظات هامة

1. **مفتاح Google Maps API**:
   - تأكد من أن مفتاح API مفعل وله صلاحيات كافية
   - تأكد من إضافة نطاقك `66.techprocode.com` إلى قائمة النطاقات المسموح بها في Google Cloud Console

2. **حدود استخدام API**:
   - انتبه إلى حدود استخدام Google Maps API
   - قد تحتاج إلى إضافة بطاقة ائتمان إلى حساب Google Cloud للاستفادة من خدمات Google Maps API

3. **أمان مفتاح API**:
   - لاحظ أن مفتاح API مكشوف في ملف PHP
   - للمزيد من الأمان، يمكنك نقل المفتاح إلى ملف تكوين منفصل أو استخدام متغيرات بيئة
