# تعليمات تشغيل التطبيق على cPanel - حل مشكلة البيانات الوهمية

## المشكلة
تم تحديد أن التطبيق يعمل بشكل صحيح على السيرفر المحلي ويُخرج بيانات حقيقية، لكن بعد رفعه على cPanel يقوم بإخراج بيانات وهمية فقط.

## الحل
قمنا بتعديل التطبيق لإضافة خاصية الاتصال المباشر بـ Google Maps API عندما يكون في بيئة cPanel، وهذا يتجاوز مشكلة الخادم الوسيط في cPanel.

## التعديلات التي تمت

1. **إضافة خيار `useDirectApi` في ملف `config.js`**:
   - تم إضافة خيار جديد `useDirectApi: true` للسماح بالاتصال المباشر بـ Google Maps API
   - تم الحفاظ على `useProxy: true` للتوافق مع الإصدارات السابقة

2. **تعديل دالة `searchPlaces` في ملف `app.js`**:
   - تمت إضافة منطق جديد للاتصال المباشر بـ Google Maps API عندما يكون `useDirectApi` مفعلاً
   - هذا يتجاوز الحاجة إلى الخادم الوسيط الذي قد لا يعمل بشكل صحيح في بيئة cPanel

## خطوات التثبيت على cPanel

1. **رفع الملفات المعدلة إلى cPanel**:
   - قم برفع جميع ملفات المشروع المعدلة إلى مجلد التطبيق في cPanel

2. **إعداد Node.js في cPanel**:
   - استخدم "Setup Node.js App" في cPanel لإعداد تطبيق Node.js
   - استخدم ملف `start.js` كنقطة بداية

3. **تشغيل التطبيق**:
   - قم بتشغيل التطبيق من لوحة تحكم cPanel
   - تأكد من عدم وجود أخطاء في السجلات

## ملاحظات هامة

1. **مفتاح Google Maps API**:
   - تأكد من أن مفتاح API مفعل وله صلاحيات كافية
   - تأكد من إضافة نطاقك `66.techprocode.com` إلى قائمة النطاقات المسموح بها في Google Cloud Console

2. **قيود CORS**:
   - قد تواجه مشكلات CORS عند الاتصال المباشر بـ Google Maps API
   - إذا واجهت مشكلات، جرب استخدام وحدة CORS في cPanel أو تعديل إعدادات الخادم

3. **حدود استخدام API**:
   - انتبه إلى حدود استخدام Google Maps API
   - قد تحتاج إلى إضافة بطاقة ائتمان إلى حساب Google Cloud للاستفادة من خدمات Google Maps API

## استكشاف الأخطاء وإصلاحها

إذا استمرت المشكلة، جرب ما يلي:

1. **تشغيل ملف الاختبار**:
   ```
   node test-api.js
   ```
   هذا سيختبر الاتصال المباشر بـ Google Maps API ويعرض النتائج.

2. **التحقق من سجلات الخطأ**:
   - راجع سجلات Node.js في cPanel للتحقق من وجود أي رسائل خطأ
   - ابحث عن رسائل مثل "استخدام الاتصال المباشر بـ Google Maps API..." للتأكد من أن الكود يستخدم الطريقة المباشرة

3. **تعديل إعدادات الخادم**:
   - قد تحتاج إلى تكوين إعدادات إضافية في cPanel للسماح بالاتصالات الخارجية
   - تواصل مع مزود الاستضافة إذا كنت بحاجة إلى مساعدة
