import { TemplateConfig } from '@/types';

export const templates: TemplateConfig[] = [
    {
        id: 'landscaping',
        name: 'تنسيق حدائق',
        description: 'تصميم طبيعي وجذاب يعكس جمال الطبيعة، مثالي لشركات تنسيق الحدائق والمشاتل.',
        thumbnail: '/thumbnails/landscaping.jpg',
        fields: [
            { id: 'companyName', label: 'اسم الشركة', type: 'text', placeholder: 'مؤسسة الطبيعة الخضراء', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'primaryColor', label: 'اللون الرئيسي', type: 'color', defaultValue: '#16a34a' },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'نحول حديقتك إلى واحة من الجمال' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'نقدم خدمات تنسيق الحدائق وتركيب العشب الصناعي والشلالات بأعلى جودة وأفضل الأسعار.' },
            { id: 'heroImage', label: 'صورة الخلفية الرئيسية', type: 'image' },

            // Stats Section
            { id: 'yearsExperience', label: 'سنوات الخبرة', type: 'text', defaultValue: '10' },
            { id: 'completedProjects', label: 'مشاريع منفذة', type: 'text', defaultValue: '100+' },

            // Services
            { id: 'service1Title', label: 'عنوان الخدمة 1', type: 'text', defaultValue: 'تنسيق حدائق' },
            { id: 'service1Desc', label: 'وصف الخدمة 1', type: 'textarea', defaultValue: 'تصميم وتنفيذ حدائق منزلية وعامة بأحدث التصاميم.' },
            { id: 'service2Title', label: 'عنوان الخدمة 2', type: 'text', defaultValue: 'تركيب عشب صناعي' },
            { id: 'service2Desc', label: 'وصف الخدمة 2', type: 'textarea', defaultValue: 'عشب صناعي عالي الجودة مقاوم للشمس والمطر.' },
            { id: 'service3Title', label: 'عنوان الخدمة 3', type: 'text', defaultValue: 'شلالات ونوافير' },
            { id: 'service3Desc', label: 'وصف الخدمة 3', type: 'textarea', defaultValue: 'إضافة لمسة جمالية بصوت الماء العذب.' },

            // Gallery
            { id: 'galleryTitle', label: 'عنوان المعرض', type: 'text', defaultValue: 'أحدث أعمالنا' },
            { id: 'galleryImage1', label: 'صورة المعرض 1', type: 'image' },
            { id: 'galleryImage2', label: 'صورة المعرض 2', type: 'image' },
            { id: 'galleryImage3', label: 'صورة المعرض 3', type: 'image' },
            { id: 'galleryImage4', label: 'صورة المعرض 4', type: 'image' },
            { id: 'galleryImage5', label: 'صورة المعرض 5', type: 'image' },
            { id: 'galleryImage6', label: 'صورة المعرض 6', type: 'image' },

            // Testimonials
            { id: 'clientName1', label: 'عميل 1 - الاسم', type: 'text', defaultValue: 'أحمد محمد' },
            { id: 'clientReview1', label: 'عميل 1 - الرأي', type: 'textarea', defaultValue: 'خدمة ممتازة وسرعة في الإنجاز. أنصح بالتعامل معهم.' },
            { id: 'clientRating1', label: 'عميل 1 - التقييم (1-5)', type: 'text', defaultValue: '5' },

            { id: 'clientName2', label: 'عميل 2 - الاسم', type: 'text', defaultValue: 'خالد عبدالله' },
            { id: 'clientReview2', label: 'عميل 2 - الرأي', type: 'textarea', defaultValue: 'فريق محترف وشغل نظيف جداً.' },
            { id: 'clientRating2', label: 'عميل 2 - التقييم (1-5)', type: 'text', defaultValue: '5' },

            { id: 'clientName3', label: 'عميل 3 - الاسم', type: 'text', defaultValue: 'سارة علي' },
            { id: 'clientReview3', label: 'عميل 3 - الرأي', type: 'textarea', defaultValue: 'حولوا حديقتي لمكان ساحر. شكراً لكم.' },
            { id: 'clientRating3', label: 'عميل 3 - التقييم (1-5)', type: 'text', defaultValue: '4' },
        ]
    },
    {
        id: 'moving',
        name: 'نقل عفش',
        description: 'تصميم يركز على السرعة والأمان، مثالي لشركات نقل الأثاث والخدمات اللوجستية.',
        thumbnail: '/thumbnails/moving.jpg',
        fields: [
            { id: 'companyName', label: 'اسم الشركة', type: 'text', placeholder: 'السريع لنقل العفش', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'primaryColor', label: 'اللون الرئيسي', type: 'color', defaultValue: '#1e3a8a' },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'نقل عفش آمن وسريع' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'فريق متخصص في فك وتركيب وتغليف الأثاث مع الضمان.' },

            { id: 'feature1', label: 'ميزة 1', type: 'text', defaultValue: 'فك وتركيب شامل' },
            { id: 'feature2', label: 'ميزة 2', type: 'text', defaultValue: 'تغليف آمن' },
            { id: 'feature3', label: 'ميزة 3', type: 'text', defaultValue: 'سيارات مجهزة' },

            // Process
            { id: 'step1Title', label: 'خطوة 1', type: 'text', defaultValue: 'الاتصال والمعاينة' },
            { id: 'step2Title', label: 'خطوة 2', type: 'text', defaultValue: 'الفك والتغليف' },
            { id: 'step3Title', label: 'خطوة 3', type: 'text', defaultValue: 'النقل والتركيب' },

            // Gallery (Fleet/Work)
            { id: 'galleryTitle', label: 'عنوان المعرض', type: 'text', defaultValue: 'أسطولنا وتجهيزاتنا' },
            { id: 'galleryImage1', label: 'صورة المعرض 1', type: 'image' },
            { id: 'galleryImage2', label: 'صورة المعرض 2', type: 'image' },
            { id: 'galleryImage3', label: 'صورة المعرض 3', type: 'image' },

            // Testimonials
            { id: 'clientName1', label: 'عميل 1 - الاسم', type: 'text', defaultValue: 'أبو عمر' },
            { id: 'clientReview1', label: 'عميل 1 - الرأي', type: 'textarea', defaultValue: 'وصل العفش سليم وفي الوقت المحدد.' },
            { id: 'clientName2', label: 'عميل 2 - الاسم', type: 'text', defaultValue: 'أم فهد' },
            { id: 'clientReview2', label: 'عميل 2 - الرأي', type: 'textarea', defaultValue: 'تعامل راقي واسعار مناسبة.' },
        ]
    },
    {
        id: 'used-furniture',
        name: 'شراء اثاث مستعمل',
        description: 'تصميم بسيط ومباشر يسهل عملية البيع والشراء، مثالي لتجار الأثاث المستعمل.',
        thumbnail: '/thumbnails/used-furniture.jpg',
        fields: [
            { id: 'companyName', label: 'اسم الشركة', type: 'text', placeholder: 'سوق النخبة للأثاث', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'primaryColor', label: 'اللون الرئيسي', type: 'color', defaultValue: '#d97706' },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'نشتري جميع أنواع الأثاث المستعمل' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'نشتري غرف النوم، المطابخ، المكيفات، والأجهزة الكهربائية بأفضل الأسعار. خدمة فورية ودفع كاش.' },
            { id: 'area', label: 'مناطق الخدمة', type: 'text', defaultValue: 'الرياض - جدة - الدمام' },

            // Stats
            { id: 'yearsExperience', label: 'سنوات الخبرة', type: 'text', defaultValue: '8' },
            { id: 'dailyCustomers', label: 'عملاء يومياً', type: 'text', defaultValue: '20+' },

            // Features (Why choose us)
            { id: 'feature1', label: 'ميزة 1', type: 'text', defaultValue: 'أفضل الأسعار' },
            { id: 'feature2', label: 'ميزة 2', type: 'text', defaultValue: 'نقل مجاني' },
            { id: 'feature3', label: 'ميزة 3', type: 'text', defaultValue: 'دفع فوري' },

            // Gallery
            { id: 'galleryTitle', label: 'عنوان المعرض', type: 'text', defaultValue: 'الأثاث الذي نشتريه' },
            { id: 'galleryImage1', label: 'صورة 1', type: 'image' },
            { id: 'galleryImage2', label: 'صورة 2', type: 'image' },
            { id: 'galleryImage3', label: 'صورة 3', type: 'image' },
            { id: 'galleryImage4', label: 'صورة 4', type: 'image' },

            // Testimonials
            { id: 'clientName1', label: 'عميل 1', type: 'text', defaultValue: 'سلطان العنزي' },
            { id: 'clientReview1', label: 'رأي 1', type: 'textarea', defaultValue: 'ما قصروا، سعرهم ممتاز وشالوا العفش بسرعة.' },
        ]
    },
    {
        id: 'contracting',
        name: 'مقاولات عامة',
        description: 'تصميم احترافي يعكس القوة والثقة، مثالي لشركات المقاولات والبناء.',
        thumbnail: '/thumbnails/contracting.jpg',
        fields: [
            { id: 'companyName', label: 'اسم الشركة', type: 'text', placeholder: 'مؤسسة البنيان للمقاولات', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'primaryColor', label: 'اللون الرئيسي', type: 'color', defaultValue: '#f59e0b' },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'نبني مستقبلك بإتقان' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'مقاولات عامة، تشطيبات، ترميم، وبناء ملاحق بأيدي خبراء.' },

            // Gallery
            { id: 'galleryTitle', label: 'عنوان المعرض', type: 'text', defaultValue: 'مشاريعنا' },
            { id: 'galleryImage1', label: 'صورة المشروع 1', type: 'image' },
            { id: 'galleryImage2', label: 'صورة المشروع 2', type: 'image' },
            { id: 'galleryImage3', label: 'صورة المشروع 3', type: 'image' },
            { id: 'galleryImage4', label: 'صورة المشروع 4', type: 'image' },

            // Stats
            { id: 'yearExp', label: 'سنوات الخبرة', type: 'text', defaultValue: '15' },
            { id: 'projectCount', label: 'مشاريع مكتملة', type: 'text', defaultValue: '500' },
        ]
    },
    {
        id: 'recruitment',
        name: 'استقدام عمالة',
        description: 'تصميم رسمي وموثوق، مثالي لمكاتب الاستقدام والخدمات العمالية.',
        thumbnail: '/thumbnails/recruitment.jpg',
        fields: [
            { id: 'companyName', label: 'اسم المكتب', type: 'text', placeholder: 'مكتب التيسير للاستقدام', required: true },
            { id: 'licenseNumber', label: 'رقم الترخيص', type: 'text', placeholder: 'ترخيص رقم: 123456' },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'primaryColor', label: 'اللون الرئيسي', type: 'color', defaultValue: '#0891b2' },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'استقدام عمالة منزلية ومهنية' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'سرعة في الإنجاز، ومصداقية في التعامل. نوفر عمالة من مختلف الجنسيات.' },
            { id: 'countries', label: 'دول الاستقدام', type: 'text', defaultValue: 'الفلبين - إندونيسيا - كينيا - أوغندا' },

            // Features (Values)
            { id: 'feature1', label: 'قيمة 1', type: 'text', defaultValue: 'سرعة الإنجاز' },
            { id: 'feature2', label: 'قيمة 2', type: 'text', defaultValue: 'عمالة مدربة' },
            { id: 'feature3', label: 'قيمة 3', type: 'text', defaultValue: 'ضمان شامل' },

            // Gallery (Visas/Workers/Office)
            { id: 'galleryTitle', label: 'عنوان المعرض', type: 'text', defaultValue: 'من خدماتنا' },
            { id: 'galleryImage1', label: 'صورة 1', type: 'image' },
            { id: 'galleryImage2', label: 'صورة 2', type: 'image' },
            { id: 'galleryImage3', label: 'صورة 3', type: 'image' },

            // Testimonials
            { id: 'clientName1', label: 'عميل 1', type: 'text', defaultValue: 'محمد القحطاني' },
            { id: 'clientReview1', label: 'رأي 1', type: 'textarea', defaultValue: 'تعامل راقي ووصلت العاملة في الوقت المحدد.' },
        ]
    },
    {
        id: 'decor',
        name: 'ديكور وتصميم داخلي',
        description: 'تصميم فني وأنيق يبرز جمال الأعمال، مثالي لمهندسي الديكور والمصممين.',
        thumbnail: '/thumbnails/decor.jpg',
        fields: [
            { id: 'companyName', label: 'اسم المصمم/الشركة', type: 'text', placeholder: 'لمسات فنية للديكور', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'تصاميم داخلية تحكي قصتك' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'نحول مساحتك إلى تحفة فنية تجمع بين الأناقة والوظيفة.' },

            // Gallery
            { id: 'galleryTitle', label: 'عنوان المعرض', type: 'text', defaultValue: 'معرض الأعمال' },
            { id: 'galleryImage1', label: 'صورة المعرض 1', type: 'image' },
            { id: 'galleryImage2', label: 'صورة المعرض 2', type: 'image' },
            { id: 'galleryImage3', label: 'صورة المعرض 3', type: 'image' },
            { id: 'galleryImage4', label: 'صورة المعرض 4', type: 'image' },
            { id: 'galleryImage5', label: 'صورة المعرض 5', type: 'image' },
            { id: 'galleryImage6', label: 'صورة المعرض 6', type: 'image' },

            // Testimonials
            { id: 'clientName1', label: 'عميل 1', type: 'text', defaultValue: 'منى ناصر' },
            { id: 'clientReview1', label: 'رأي 1', type: 'textarea', defaultValue: 'ذوق رفيع واهتمام بالتفاصيل.' },
            { id: 'clientName2', label: 'عميل 2', type: 'text', defaultValue: 'فيصل عبدالرحمن' },
            { id: 'clientReview2', label: 'رأي 2', type: 'textarea', defaultValue: 'تصميم عصري ومميز.' },
        ]
    },
    {
        id: 'pest-control',
        name: 'رش حشرات',
        description: 'تصميم نظيف يوحي بالتعقيم والحماية، مثالي لشركات مكافحة الحشرات.',
        thumbnail: '/thumbnails/pest-control.jpg',
        fields: [
            { id: 'companyName', label: 'اسم الشركة', type: 'text', placeholder: 'الدرع لمكافحة الحشرات', required: true },
            { id: 'phone', label: 'رقم الهاتف', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'whatsapp', label: 'رقم الواتساب', type: 'tel', placeholder: '05xxxxxxxx', required: true },
            { id: 'primaryColor', label: 'اللون الرئيسي', type: 'color', defaultValue: '#0ea5e9' },
            { id: 'heroTitle', label: 'العنوان الرئيسي', type: 'text', defaultValue: 'تخلص من الحشرات نهائياً' },
            { id: 'heroDescription', label: 'وصف مختصر', type: 'textarea', defaultValue: 'مكافحة جميع أنواع الحشرات والقوارض بمبيدات آمنة وفعالة مع الضمان.' },
            { id: 'guarantee', label: 'مدة الضمان', type: 'text', defaultValue: 'ضمان 6 أشهر' },

            // Features
            { id: 'feature1', label: 'ميزة 1', type: 'text', defaultValue: 'مبيدات آمنة' },
            { id: 'feature2', label: 'ميزة 2', type: 'text', defaultValue: 'زيارات دورية' },
            { id: 'feature3', label: 'ميزة 3', type: 'text', defaultValue: 'بدون رائحة' },

            // Gallery (Equipment/Results)
            { id: 'galleryTitle', label: 'عنوان المعرض', type: 'text', defaultValue: 'معرض الصور' },
            { id: 'galleryImage1', label: 'صورة 1', type: 'image' },
            { id: 'galleryImage2', label: 'صورة 2', type: 'image' },
            { id: 'galleryImage3', label: 'صورة 3', type: 'image' },

            // Testimonials
            { id: 'clientName1', label: 'عميل 1', type: 'text', defaultValue: 'عبدالله' },
            { id: 'clientReview1', label: 'رأي 1', type: 'textarea', defaultValue: 'خدمة ممتازة وتخلصت من النمل نهائي.' },
        ]
    },
];
