'use client';

import { useEffect } from 'react';

export default function ViewTracker({ projectId }: { projectId: string }) {
    useEffect(() => {
        // Simple view tracking on mount
        // In a real app, you'd want to debounce this or use a more robust solution
        // to prevent counting duplicate views from the same session/user if desired.
        // For now, we count every page load.

        const trackView = async () => {
            try {
                await fetch('/api/analytics/view', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ projectId })
                });
            } catch (error) {
                console.error('Failed to track view', error);
            }
        };

        trackView();
    }, [projectId]);

    return null;
}
