async function main() {
    try {
        console.log('Testing API...');
        const res = await fetch('http://localhost:4000/api/projects', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                name: 'API Test Project',
                templateId: 'landscaping',
                data: { test: 'true' }
            })
        });

        console.log('Status:', res.status);
        const text = await res.text();
        console.log('Response Body:', text.substring(0, 500)); // Print first 500 chars
    } catch (e) {
        console.error('API Test Failed:', e);
    }
}

main();
