<?php
// templates/used-furniture.php
$data = $data ?? [];
?>
<div class="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
    <!-- Hero Section -->
    <header class="bg-amber-50 py-20 border-b border-amber-100">
        <div class="container mx-auto px-4 text-center">
            <span class="inline-block bg-amber-200 text-amber-900 px-4 py-1 rounded-full text-sm font-bold mb-6">نشتري
                بأعلى الأسعار</span>
            <h1 class="text-4xl md:text-6xl font-black mb-6 text-amber-950">
                <?= htmlspecialchars($data['heroTitle'] ?? '') ?></h1>
            <p class="text-xl text-amber-800 mb-10 max-w-3xl mx-auto">
                <?= htmlspecialchars($data['heroDescription'] ?? '') ?></p>

            <div class="bg-white p-6 rounded-2xl shadow-xl max-w-2xl mx-auto border border-amber-100">
                <p class="text-lg font-bold mb-4 text-gray-700">تواصل معنا الآن لتقييم أثاثك فوراً</p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="tel:<?= htmlspecialchars($data['phone'] ?? '') ?>"
                        class="flex-1 bg-amber-600 hover:bg-amber-700 text-white py-4 rounded-xl font-bold flex items-center justify-center gap-2 transition-colors text-lg">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path
                                d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                            </path>
                        </svg>
                        اتصال: <?= htmlspecialchars($data['phone'] ?? '') ?>
                    </a>
                    <a href="https://wa.me/<?= htmlspecialchars($data['whatsapp'] ?? '') ?>"
                        class="flex-1 bg-green-500 hover:bg-green-600 text-white py-4 rounded-xl font-bold flex items-center justify-center gap-2 transition-colors text-lg">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path
                                d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z">
                            </path>
                        </svg>
                        واتساب
                    </a>
                </div>
            </div>
        </div>
    </header>

    <!-- What We Buy -->
    <section class="py-16">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl font-bold text-center mb-12 text-gray-800">ماذا نشتري؟</h2>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                <?php
                $items = ['غرف نوم', 'مطابخ', 'مكيفات', 'أجهزة كهربائية', 'مجالس', 'سجاد', 'أثاث مكتبي', 'خردة'];
                foreach ($items as $item): ?>
                    <div
                        class="bg-gray-50 p-6 rounded-xl text-center hover:bg-amber-50 transition-colors cursor-default border border-gray-100">
                        <!-- Icon Placeholder -->
                        <div class="w-8 h-8 mx-auto mb-3 text-amber-600">🪑</div>
                        <span class="font-bold text-gray-700"><?= $item ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Service Areas -->
    <section class="py-12 bg-gray-900 text-white text-center">
        <div class="container mx-auto px-4">
            <h3 class="text-xl font-bold mb-4">مناطق الخدمة</h3>
            <p class="text-gray-400 text-lg"><?= htmlspecialchars($data['area'] ?? '') ?></p>
        </div>
    </section>

    <footer class="py-6 text-center text-gray-500 text-sm">
        &copy; <?= date('Y') ?> <?= htmlspecialchars($data['companyName'] ?? '') ?>
    </footer>
</div>