<?php
// templates/moving.php
$data = $data ?? [];
?>
<div class="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
    <header class="bg-indigo-600 text-white py-20">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-4xl md:text-6xl font-bold mb-6"><?= htmlspecialchars($data['heroTitle'] ?? '') ?></h1>
            <p class="text-xl text-indigo-100 mb-10 max-w-3xl mx-auto">
                <?= htmlspecialchars($data['heroDescription'] ?? '') ?></p>
            <div class="flex gap-4 justify-center">
                <a href="tel:<?= htmlspecialchars($data['phone'] ?? '') ?>"
                    class="bg-white text-indigo-600 px-8 py-3 rounded-full font-bold hover:bg-indigo-50 transition-colors">اتصل
                    الآن</a>
            </div>
        </div>
    </header>

    <div class="container mx-auto px-4 py-16">
        <div class="grid md:grid-cols-3 gap-8 text-center">
            <div class="p-6 bg-gray-50 rounded-lg">
                <h3 class="font-bold text-xl mb-2"><?= htmlspecialchars($data['feature1'] ?? '') ?></h3>
            </div>
            <div class="p-6 bg-gray-50 rounded-lg">
                <h3 class="font-bold text-xl mb-2"><?= htmlspecialchars($data['feature2'] ?? '') ?></h3>
            </div>
            <div class="p-6 bg-gray-50 rounded-lg">
                <h3 class="font-bold text-xl mb-2"><?= htmlspecialchars($data['feature3'] ?? '') ?></h3>
            </div>
        </div>
    </div>
</div>