<?php
// templates/landscaping.php
// Expected variables: $data (associative array)
$data = $data ?? [];
?>
<div class="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
    <!-- Hero -->
    <header class="relative h-[600px] bg-green-900 text-white">
        <div class="absolute inset-0 bg-cover bg-center opacity-40"
            style="background-image: url('<?= htmlspecialchars($data['heroImage'] ?? 'https://images.unsplash.com/photo-1557804506-669a67965ba0?auto=format&fit=crop&q=80') ?>');">
        </div>
        <div class="absolute inset-0 bg-gradient-to-b from-transparent to-green-900/90"></div>

        <div class="relative container mx-auto px-4 h-full flex flex-col justify-center text-center">
            <h1 class="text-5xl md:text-7xl font-bold mb-6 drop-shadow-lg">
                <?= htmlspecialchars($data['heroTitle'] ?? '') ?></h1>
            <p class="text-xl md:text-2xl text-green-100 mb-10 max-w-3xl mx-auto drop-shadow">
                <?= htmlspecialchars($data['heroDescription'] ?? '') ?></p>

            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="tel:<?= htmlspecialchars($data['phone'] ?? '') ?>"
                    class="bg-green-600 hover:bg-green-500 text-white px-8 py-4 rounded-full font-bold flex items-center justify-center gap-2 transition-transform hover:scale-105 shadow-lg lg:text-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path
                            d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                        </path>
                    </svg>
                    اتصل الآن: <?= htmlspecialchars($data['phone'] ?? '') ?>
                </a>
                <a href="https://wa.me/<?= htmlspecialchars($data['whatsapp'] ?? '') ?>"
                    class="bg-white text-green-800 hover:bg-gray-100 px-8 py-4 rounded-full font-bold flex items-center justify-center gap-2 transition-transform hover:scale-105 shadow-lg lg:text-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path
                            d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z">
                        </path>
                    </svg>
                    واتساب
                </a>
            </div>
        </div>
    </header>

    <!-- Services -->
    <section class="py-20 bg-green-50">
        <div class="container mx-auto px-4">
            <h2 class="text-4xl font-bold text-center mb-16 text-green-900">خدماتنا المتميزة</h2>

            <div class="grid md:grid-cols-3 gap-8">
                <!-- Service 1 -->
                <div
                    class="bg-white rounded-2xl p-8 shadow-xl border-t-4 border-green-500 hover:-translate-y-2 transition-transform duration-300">
                    <div
                        class="w-16 h-16 bg-green-100 text-green-600 rounded-full flex items-center justify-center mb-6 mx-auto">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M12 19.5v-15" />
                            <path d="M5 19.5V10" />
                            <path d="M19 19.5V10" />
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-4 text-center text-gray-800">
                        <?= htmlspecialchars($data['service1Title'] ?? 'تنسيق حدائق') ?></h3>
                    <p class="text-gray-600 text-center leading-relaxed">
                        <?= htmlspecialchars($data['service1Desc'] ?? '') ?></p>
                </div>

                <!-- Service 2 -->
                <div
                    class="bg-white rounded-2xl p-8 shadow-xl border-t-4 border-green-500 hover:-translate-y-2 transition-transform duration-300">
                    <div
                        class="w-16 h-16 bg-green-100 text-green-600 rounded-full flex items-center justify-center mb-6 mx-auto">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="2" y="7" width="20" height="14" rx="2" ry="2" />
                            <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16" />
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-4 text-center text-gray-800">
                        <?= htmlspecialchars($data['service2Title'] ?? 'عشب صناعي') ?></h3>
                    <p class="text-gray-600 text-center leading-relaxed">
                        <?= htmlspecialchars($data['service2Desc'] ?? '') ?></p>
                </div>

                <!-- Service 3 -->
                <div
                    class="bg-white rounded-2xl p-8 shadow-xl border-t-4 border-green-500 hover:-translate-y-2 transition-transform duration-300">
                    <div
                        class="w-16 h-16 bg-green-100 text-green-600 rounded-full flex items-center justify-center mb-6 mx-auto">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path
                                d="M12 2.69l5.74 5.74a3 3 0 0 1 0 4.24l-5.74 5.74-5.74-5.74a3 3 0 0 1 0-4.24L12 2.69z" />
                            <circle cx="12" cy="12" r="2" />
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-4 text-center text-gray-800">
                        <?= htmlspecialchars($data['service3Title'] ?? 'شلالات ونوافير') ?></h3>
                    <p class="text-gray-600 text-center leading-relaxed">
                        <?= htmlspecialchars($data['service3Desc'] ?? '') ?></p>
                </div>
            </div>
        </div>
    </section>

    <!-- Project Gallery Setup (Optional/Static for now) -->

    <footer class="bg-green-900 text-white py-12">
        <div class="container mx-auto px-4 text-center">
            <h3 class="text-2xl font-bold mb-6"><?= htmlspecialchars($data['companyName'] ?? '') ?></h3>
            <p class="mb-8 max-w-2xl mx-auto opacity-80"><?= htmlspecialchars($data['heroDescription'] ?? '') ?></p>
            <div class="flex justify-center gap-6 mb-8">
                <!-- Social Icons could go here -->
            </div>
            <p class="text-sm opacity-50">&copy; <?= date('Y') ?> جميع الحقوق محفوظة</p>
        </div>
    </footer>
</div>