<?php
// templates/decor.php
$data = $data ?? [];
?>
<div class="font-sans text-gray-800 bg-stone-50 min-h-full" dir="rtl">
    <header class="bg-stone-900 text-stone-100 py-24">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-5xl font-light mb-6 tracking-wide"><?= htmlspecialchars($data['heroTitle'] ?? '') ?></h1>
            <p class="text-xl text-stone-400 mb-10 max-w-2xl mx-auto font-light">
                <?= htmlspecialchars($data['heroDescription'] ?? '') ?></p>
        </div>
    </header>

    <section class="py-20">
        <div class="container mx-auto px-4">
            <div class="grid md:grid-cols-3 gap-8">
                <?php foreach (['portfolio1', 'portfolio2', 'portfolio3'] as $p): ?>
                    <div class="aspect-square bg-gray-200">
                        <?php if (!empty($data[$p])): ?>
                            <img src="<?= htmlspecialchars($data[$p]) ?>" class="w-full h-full object-cover" />
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
</div>