<?php
// templates/contracting.php
$data = $data ?? [];
?>
<div class="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
    <!-- Hero -->
    <header class="relative h-[600px] bg-gray-900 text-white">
        <!-- Background Image -->
        <div class="absolute inset-0 bg-cover bg-center opacity-30"
            style="background-image: url('https://images.unsplash.com/photo-1503387762-592deb58ef4e?auto=format&fit=crop&q=80');">
        </div>
        <div class="absolute inset-0 bg-gradient-to-r from-black/80 to-transparent"></div>

        <div class="relative container mx-auto px-4 h-full flex flex-col justify-center">
            <div class="max-w-2xl border-r-4 border-yellow-500 pr-8">
                <h1 class="text-5xl font-bold mb-6 leading-tight"><?= htmlspecialchars($data['heroTitle'] ?? '') ?></h1>
                <p class="text-xl text-gray-300 mb-10"><?= htmlspecialchars($data['heroDescription'] ?? '') ?></p>
                <div class="flex gap-4">
                    <a href="tel:<?= htmlspecialchars($data['phone'] ?? '') ?>"
                        class="bg-yellow-500 hover:bg-yellow-400 text-black px-8 py-3 rounded font-bold flex items-center gap-2 transition-colors uppercase tracking-wider">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path
                                d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                            </path>
                        </svg>
                        اطلب عرض سعر
                    </a>
                </div>
            </div>
        </div>
    </header>

    <!-- Services Grid -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="grid md:grid-cols-3 gap-8 -mt-32 relative z-10">
                <div class="bg-white p-8 shadow-lg border-b-4 border-yellow-500">
                    <div class="w-12 h-12 text-yellow-500 mb-6">👷</div>
                    <h3 class="text-xl font-bold mb-4">مقاولات عامة</h3>
                    <p class="text-gray-600">تنفيذ جميع أعمال البناء والإنشاءات بأعلى معايير الجودة.</p>
                </div>
                <div class="bg-white p-8 shadow-lg border-b-4 border-yellow-500">
                    <div class="w-12 h-12 text-yellow-500 mb-6">📐</div>
                    <h3 class="text-xl font-bold mb-4">تشطيبات وديكور</h3>
                    <p class="text-gray-600">تشطيبات داخلية وخارجية، دهانات، جبس بورد، وأرضيات.</p>
                </div>
                <div class="bg-white p-8 shadow-lg border-b-4 border-yellow-500">
                    <div class="w-12 h-12 text-yellow-500 mb-6">🔨</div>
                    <h3 class="text-xl font-bold mb-4">ترميم وصيانة</h3>
                    <p class="text-gray-600">إعادة تأهيل المباني القديمة وصيانتها وإصلاح التصدعات.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Projects Gallery -->
    <section class="py-20 bg-gray-100">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl font-bold text-center mb-12">مشاريعنا</h2>
            <div class="grid md:grid-cols-2 gap-8">
                <!-- Project 1 -->
                <div class="h-64 bg-gray-300 rounded-lg relative overflow-hidden group">
                    <?php if (!empty($data['project1'])): ?>
                        <img src="<?= htmlspecialchars($data['project1']) ?>" alt="Project 1"
                            class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110" />
                    <?php else: ?>
                        <div class="flex items-center justify-center h-full text-gray-500">صورة المشروع 1</div>
                    <?php endif; ?>
                </div>
                <!-- Project 2 -->
                <div class="h-64 bg-gray-300 rounded-lg relative overflow-hidden group">
                    <?php if (!empty($data['project2'])): ?>
                        <img src="<?= htmlspecialchars($data['project2']) ?>" alt="Project 2"
                            class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110" />
                    <?php else: ?>
                        <div class="flex items-center justify-center h-full text-gray-500">صورة المشروع 2</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Bar -->
    <div class="bg-yellow-500 py-12">
        <div class="container mx-auto px-4 flex flex-col md:flex-row items-center justify-between gap-6">
            <div>
                <h2 class="text-2xl font-bold text-black mb-2">هل لديك مشروع؟</h2>
                <p class="text-black/80">نحن هنا لتحويل رؤيتك إلى واقع. تواصل معنا اليوم.</p>
            </div>
            <div class="flex gap-4">
                <a href="tel:<?= htmlspecialchars($data['phone'] ?? '') ?>"
                    class="bg-black text-white px-8 py-3 rounded font-bold hover:bg-gray-800 transition-colors">
                    <?= htmlspecialchars($data['phone'] ?? '') ?>
                </a>
                <a href="https://wa.me/<?= htmlspecialchars($data['whatsapp'] ?? '') ?>"
                    class="bg-white text-black px-8 py-3 rounded font-bold hover:bg-gray-100 transition-colors">
                    واتساب
                </a>
            </div>
        </div>
    </div>
</div>