import type { IncomingMessage, ServerResponse } from 'node:http';
import type { NextConfigComplete } from '../../config-shared';
import type { UrlWithParsedQuery } from 'node:url';
import type { ServerCacheStatus } from '../../../next-devtools/dev-overlay/cache-indicator';
export type RevalidateFn = (config: {
    urlPath: string;
    revalidateHeaders: {
        [key: string]: string | string[];
    };
    opts: {
        unstable_onlyGenerated?: boolean;
    };
}) => Promise<void>;
export type RouterServerContext = Record<string, {
    hostname?: string;
    revalidate?: RevalidateFn;
    render404?: (req: IncomingMessage, res: ServerResponse, parsedUrl?: UrlWithParsedQuery, setHeaders?: boolean) => Promise<void>;
    nextConfig?: NextConfigComplete;
    isCustomServer?: boolean;
    experimentalTestProxy?: boolean;
    logErrorWithOriginalStack?: (err: unknown, type: string) => void;
    setIsrStatus?: (key: string, value: boolean | undefined) => void;
    setReactDebugChannel?: (debugChannel: {
        readable: ReadableStream<Uint8Array>;
    }, htmlRequestId: string, requestId: string) => void;
    setCacheStatus?: (status: ServerCacheStatus, htmlRequestId: string) => void;
}>;
export declare const RouterServerContextSymbol: unique symbol;
export declare const routerServerGlobal: typeof globalThis & {
    [RouterServerContextSymbol]?: RouterServerContext;
};
