# Deployment Guide for Site2

This guide assumes you are deploying to a Linux VPS (Ubuntu/Debian/CentOS).

## 1. Prerequisites (On the Server)

Connect to your server via SSH and install Node.js (version 20+) and PM2.

```bash
# Update package list
sudo apt update

# Install Node.js 20 (if not installed)
curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
sudo apt install -y nodejs

# Install PM2 globally
sudo npm install -g pm2
```

## 2. Setup Application

1. Upload the contents of your `vps-bundle` folder (or the zip) to your server (e.g., `/var/www/site2`).
2. Navigate to the directory:
   ```bash
   cd /var/www/site2
   ```
3. Copy the `ecosystem.config.js` file to this directory if it's not already there.

## 3. Run with PM2

Start the application using PM2:

```bash
pm2 start ecosystem.config.js
pm2 save
pm2 startup
```

(Follow the instructions output by `pm2 startup` to potential enable auto-start on reboot).

## 4. Configure Nginx (Reverse Proxy)

To access your site via your domain (without port 3000), install and configure Nginx.

1. Install Nginx:
   ```bash
   sudo apt install nginx
   ```

2. Create a configuration file:
   ```bash
   sudo nano /etc/nginx/sites-available/site2
   ```

3. Paste the following configuration (replace `test.techprocode.com` with your actual domain):

   ```nginx
   server {
       listen 80;
       server_name test.techprocode.com;

       location / {
           proxy_pass http://localhost:3000;
           proxy_http_version 1.1;
           proxy_set_header Upgrade $http_upgrade;
           proxy_set_header Connection 'upgrade';
           proxy_set_header Host $host;
           proxy_cache_bypass $http_upgrade;
       }
   }
   ```

4. Enable the site and restart Nginx:
   ```bash
   sudo ln -s /etc/nginx/sites-available/site2 /etc/nginx/sites-enabled/
   sudo nginx -t
   sudo systemctl restart nginx
   ```

## 5. Verify

Visit `http://test.techprocode.com` in your browser. You should see your application running.
