<?php
/**
 * صفحة عرض المشاريع
 * Public Project Display Page
 */

define('APP_PATH', __DIR__);
require_once APP_PATH . '/config/config.php';
require_once APP_PATH . '/config/database.php';
require_once APP_PATH . '/includes/functions.php';
require_once APP_PATH . '/auth/session.php';

$slug = $_GET['slug'] ?? '';

if (empty($slug)) {
    die('معرّف الصفحة مفقود');
}

// جلب المشروع
$sql = "SELECT * FROM projects WHERE slug = :slug";
$project = fetchOne($sql, ['slug' => $slug]);

if (!$project) {
    header("HTTP/1.0 404 Not Found");
    die('الصفحة غير موجودة');
}

// فك تشفير البيانات
$data = json_decode($project['data'], true);

// زيادة عداد الزيارات
$db = getDB();
$updateSql = "UPDATE projects SET views = views + 1 WHERE id = :id";
$stmt = $db->prepare($updateSql);
$stmt->execute(['id' => $project['id']]);

// الحصول على اللون الرئيسي
$primaryColor = $data['primaryColor'] ?? '#3b82f6';
$companyName = $data['companyName'] ?? 'الشركة';
$phone = $data['phone'] ?? '';
$whatsapp = $data['whatsapp'] ?? $phone;
$heroTitle = $data['heroTitle'] ?? 'مرحباً بك';
$heroDescription = $data['heroDescription'] ?? '';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($companyName); ?> - <?php echo htmlspecialchars($project['name']); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars(substr($heroDescription, 0, 160)); ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700;900&display=swap');
        body { font-family: 'Cairo', sans-serif; }
        .primary-bg { background-color: <?php echo $primaryColor; ?>; }
        .primary-text { color: <?php echo $primaryColor; ?>; }
        .primary-border { border-color: <?php echo $primaryColor; ?>; }
    </style>
</head>
<body class="bg-gray-50">

<!-- Hero Section -->
<section class="primary-bg text-white py-20 md:py-32">
    <div class="max-w-6xl mx-auto px-4 text-center">
        <h1 class="text-4xl md:text-6xl font-black mb-6"><?php echo htmlspecialchars($companyName); ?></h1>
        <h2 class="text-2xl md:text-3xl font-bold mb-6"><?php echo htmlspecialchars($heroTitle); ?></h2>
        <p class="text-xl md:text-2xl text-white/90 max-w-3xl mx-auto mb-8"><?php echo htmlspecialchars($heroDescription); ?></p>
        
        <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <?php if ($phone): ?>
                <a href="tel:<?php echo htmlspecialchars($phone); ?>" class="bg-white text-gray-900 px-8 py-4 rounded-lg font-bold text-lg hover:bg-gray-100 transition-colors inline-flex items-center gap-2">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                    </svg>
                    اتصل الآن
                </a>
            <?php endif; ?>
            
            <?php if ($whatsapp): ?>
                <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp); ?>" target="_blank" class="bg-green-500 text-white px-8 py-4 rounded-lg font-bold text-lg hover:bg-green-600 transition-colors inline-flex items-center gap-2">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                    </svg>
                    واتساب
                </a>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="py-16 bg-white">
    <div class="max-w-6xl mx-auto px-4">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 text-center">
            <div class="p-6">
                <div class="w-16 h-16 primary-bg rounded-full flex items-center justify-center mx-auto mb-4 text-white">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold mb-2">جودة عالية</h3>
                <p class="text-gray-600">نقدم أفضل الخدمات بأعلى معايير الجودة</p>
            </div>
            
            <div class="p-6">
                <div class="w-16 h-16 primary-bg rounded-full flex items-center justify-center mx-auto mb-4 text-white">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold mb-2">سرعة في الإنجاز</h3>
                <p class="text-gray-600">نلتزم بالمواعيد ونقدم خدمة سريعة</p>
            </div>
            
            <div class="p-6">
                <div class="w-16 h-16 primary-bg rounded-full flex items-center justify-center mx-auto mb-4 text-white">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold mb-2">دعم مستمر</h3>
                <p class="text-gray-600">فريقنا جاهز لخدمتك على مدار الساعة</p>
            </div>
        </div>
    </div>
</section>

<!-- Contact Section -->
<section class="py-16 primary-bg text-white">
    <div class="max-w-4xl mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold mb-6">تواصل معنا الآن</h2>
        <p class="text-xl mb-8 text-white/90">نحن في خدمتك دائماً</p>
        
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <?php if ($phone): ?>
                <a href="tel:<?php echo htmlspecialchars($phone); ?>" class="bg-white text-gray-900 px-8 py-4 rounded-lg font-bold text-lg hover:bg-gray-100 transition-colors">
                    <?php echo htmlspecialchars($phone); ?>
                </a>
            <?php endif; ?>
            
            <?php if ($whatsapp && $whatsapp !== $phone): ?>
                <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp); ?>" target="_blank" class="bg-green-500 text-white px-8 py-4 rounded-lg font-bold text-lg hover:bg-green-600 transition-colors">
                    واتساب: <?php echo htmlspecialchars($whatsapp); ?>
                </a>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Footer -->
<footer class="bg-gray-900 text-white py-8">
    <div class="max-w-6xl mx-auto px-4 text-center">
        <p class="text-gray-400">جميع الحقوق محفوظة © <?php echo date('Y'); ?> - <?php echo htmlspecialchars($companyName); ?></p>
        <p class="text-gray-500 text-sm mt-2">تم إنشاء هذه الصفحة بواسطة <?php echo SITE_NAME; ?></p>
    </div>
</footer>

</body>
</html>
