<?php
/**
 * معالج التثبيت التلقائي
 * Automatic Installer
 */

// التحقق من التثبيت السابق
define('APP_PATH', __DIR__);

$configFile = APP_PATH . '/config/config.php';
$installed = false;

if (file_exists($configFile)) {
    require_once $configFile;
    if (defined('DB_NAME')) {
        try {
            $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
            $stmt = $pdo->query("SELECT setting_value FROM settings WHERE setting_key = 'installed'");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($result && $result['setting_value'] == '1') {
                $installed = true;
            }
        } catch (PDOException $e) {
            // قاعدة البيانات غير موجودة
        }
    }
}

if ($installed && !isset($_GET['force'])) {
    header('Location: index.php');
    exit;
}

$step = $_GET['step'] ?? 1;
$error = '';
$success = '';

// معالجة الخطوات
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($step == 1) {
        // فحص المتطلبات
        $step = 2;
    } elseif ($step == 2) {
        // إعداد قاعدة البيانات
        $dbHost = $_POST['db_host'] ?? 'localhost';
        $dbName = $_POST['db_name'] ?? '';
        $dbUser = $_POST['db_user'] ?? '';
        $dbPass = $_POST['db_pass'] ?? '';
        
        try {
            $pdo = new PDO("mysql:host=$dbHost", $dbUser, $dbPass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // إنشاء قاعدة البيانات
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbName` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $pdo->exec("USE `$dbName`");
            
            // تنفيذ الـ SQL
            $sql = file_get_contents(APP_PATH . '/database.sql');
            $pdo->exec($sql);
            
            // حفظ إعدادات قاعدة البيانات
            $configContent = file_get_contents($configFile);
            $configContent = str_replace("define('DB_HOST', 'localhost');", "define('DB_HOST', '$dbHost');", $configContent);
            $configContent = str_replace("define('DB_NAME', 'landing_page_db');", "define('DB_NAME', '$dbName');", $configContent);
            $configContent = str_replace("define('DB_USER', 'root');", "define('DB_USER', '$dbUser');", $configContent);
            $configContent = str_replace("define('DB_PASS', '');", "define('DB_PASS', '$dbPass');", $configContent);
            file_put_contents($configFile, $configContent);
            
            $step = 3;
        } catch (PDOException $e) {
            $error = 'خطأ في الاتصال بقاعدة البيانات: ' . $e->getMessage();
        }
    } elseif ($step == 3) {
        // إعداد Google OAuth
        $clientId = $_POST['google_client_id'] ?? '';
        $clientSecret = $_POST['google_client_secret'] ?? '';
        $siteUrl = $_POST['site_url'] ?? '';
        
        $configContent = file_get_contents($configFile);
        $configContent = str_replace("define('GOOGLE_CLIENT_ID', 'YOUR_GOOGLE_CLIENT_ID');", "define('GOOGLE_CLIENT_ID', '$clientId');", $configContent);
        $configContent = str_replace("define('GOOGLE_CLIENT_SECRET', 'YOUR_GOOGLE_CLIENT_SECRET');", "define('GOOGLE_CLIENT_SECRET', '$clientSecret');", $configContent);
        $configContent = str_replace("define('SITE_URL', 'http://localhost/site2/cpanel-version');", "define('SITE_URL', '$siteUrl');", $configContent);
        file_put_contents($configFile, $configContent);
        
        // تحديث حالة التثبيت
        require_once APP_PATH . '/config/database.php';
        update('settings', ['setting_value' => '1'], "setting_key = 'installed'");
        
        $step = 4;
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تثبيت لاندنج بيج</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap');
        body { font-family: 'Cairo', sans-serif; }
    </style>
</head>
<body class="bg-gray-50">

<div class="min-h-screen flex items-center justify-center py-12 px-4">
    <div class="max-w-2xl w-full">
        <div class="bg-white rounded-xl shadow-lg p-8">
            <div class="text-center mb-8">
                <div class="w-16 h-16 bg-blue-600 rounded-lg flex items-center justify-center mx-auto mb-4">
                    <span class="text-white font-bold text-2xl">L</span>
                </div>
                <h1 class="text-3xl font-bold text-gray-900">تثبيت لاندنج بيج</h1>
                <p class="text-gray-500 mt-2">معالج التثبيت السريع</p>
            </div>

            <!-- Progress Steps -->
            <div class="flex justify-between mb-8">
                <div class="flex-1 text-center">
                    <div class="w-10 h-10 mx-auto rounded-full <?php echo $step >= 1 ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-600'; ?> flex items-center justify-center font-bold">1</div>
                    <div class="text-xs mt-2">المتطلبات</div>
                </div>
                <div class="flex-1 text-center">
                    <div class="w-10 h-10 mx-auto rounded-full <?php echo $step >= 2 ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-600'; ?> flex items-center justify-center font-bold">2</div>
                    <div class="text-xs mt-2">قاعدة البيانات</div>
                </div>
                <div class="flex-1 text-center">
                    <div class="w-10 h-10 mx-auto rounded-full <?php echo $step >= 3 ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-600'; ?> flex items-center justify-center font-bold">3</div>
                    <div class="text-xs mt-2">الإعدادات</div>
                </div>
                <div class="flex-1 text-center">
                    <div class="w-10 h-10 mx-auto rounded-full <?php echo $step >= 4 ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-600'; ?> flex items-center justify-center font-bold">4</div>
                    <div class="text-xs mt-2">اكتمل</div>
                </div>
            </div>

            <?php if ($error): ?>
                <div class="bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-lg mb-6">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <?php if ($success): ?>
                <div class="bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-lg mb-6">
                    <?php echo htmlspecialchars($success); ?>
                </div>
            <?php endif; ?>

            <!-- Step 1: Requirements -->
            <?php if ($step == 1): ?>
                <div class="space-y-4">
                    <h2 class="text-xl font-bold mb-4">فحص المتطلبات</h2>
                    
                    <div class="space-y-3">
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <span>PHP Version (7.4+)</span>
                            <span class="text-green-600 font-bold">✓ <?php echo PHP_VERSION; ?></span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <span>PDO Extension</span>
                            <span class="<?php echo extension_loaded('pdo') ? 'text-green-600' : 'text-red-600'; ?> font-bold">
                                <?php echo extension_loaded('pdo') ? '✓ متوفر' : '✗ غير متوفر'; ?>
                            </span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <span>PDO MySQL</span>
                            <span class="<?php echo extension_loaded('pdo_mysql') ? 'text-green-600' : 'text-red-600'; ?> font-bold">
                                <?php echo extension_loaded('pdo_mysql') ? '✓ متوفر' : '✗ غير متوفر'; ?>
                            </span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <span>cURL</span>
                            <span class="<?php echo extension_loaded('curl') ? 'text-green-600' : 'text-red-600'; ?> font-bold">
                                <?php echo extension_loaded('curl') ? '✓ متوفر' : '✗ غير متوفر'; ?>
                            </span>
                        </div>
                    </div>

                    <form method="POST" action="?step=1">
                        <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 rounded-lg mt-6">
                            التالي
                        </button>
                    </form>
                </div>
            <?php endif; ?>

            <!-- Step 2: Database -->
            <?php if ($step == 2): ?>
                <form method="POST" action="?step=2" class="space-y-4">
                    <h2 class="text-xl font-bold mb-4">إعداد قاعدة البيانات</h2>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">اسم السيرفر</label>
                        <input type="text" name="db_host" value="localhost" class="w-full px-4 py-2 border border-gray-300 rounded-lg" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">اسم قاعدة البيانات</label>
                        <input type="text" name="db_name" value="landing_page_db" class="w-full px-4 py-2 border border-gray-300 rounded-lg" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">اسم المستخدم</label>
                        <input type="text" name="db_user" value="root" class="w-full px-4 py-2 border border-gray-300 rounded-lg" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">كلمة المرور</label>
                        <input type="password" name="db_pass" class="w-full px-4 py-2 border border-gray-300 rounded-lg">
                    </div>

                    <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 rounded-lg mt-6">
                        إنشاء قاعدة البيانات
                    </button>
                </form>
            <?php endif; ?>

            <!-- Step 3: Settings -->
            <?php if ($step == 3): ?>
                <form method="POST" action="?step=3" class="space-y-4">
                    <h2 class="text-xl font-bold mb-4">الإعدادات العامة</h2>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">رابط الموقع</label>
                        <input type="url" name="site_url" value="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']); ?>" class="w-full px-4 py-2 border border-gray-300 rounded-lg" required>
                        <p class="text-xs text-gray-500 mt-1">بدون شرطة مائلة في النهاية</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Google Client ID</label>
                        <input type="text" name="google_client_id" class="w-full px-4 py-2 border border-gray-300 rounded-lg" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Google Client Secret</label>
                        <input type="text" name="google_client_secret" class="w-full px-4 py-2 border border-gray-300 rounded-lg" required>
                    </div>

                    <div class="bg-blue-50 border border-blue-200 p-4 rounded-lg text-sm">
                        <p class="font-bold text-blue-900 mb-2">كيفية الحصول على Google OAuth:</p>
                        <ol class="list-decimal mr-5 space-y-1 text-blue-800">
                            <li>اذهب إلى <a href="https://console.cloud.google.com/" target="_blank" class="underline">Google Cloud Console</a></li>
                            <li>أنشئ مشروع جديد</li>
                            <li>فعّل Google+ API</li>
                            <li>أنشئ OAuth 2.0 Client ID</li>
                            <li>أضف Redirect URI: <code class="bg-white px-2 py-1 rounded"><?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']); ?>/auth/google-callback.php</code></li>
                        </ol>
                    </div>

                    <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 rounded-lg mt-6">
                        إكمال التثبيت
                    </button>
                </form>
            <?php endif; ?>

            <!-- Step 4: Complete -->
            <?php if ($step == 4): ?>
                <div class="text-center py-8">
                    <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-10 h-10 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                    </div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-2">تم التثبيت بنجاح!</h2>
                    <p class="text-gray-600 mb-6">يمكنك الآن البدء باستخدام نظام لاندنج بيج</p>
                    
                    <a href="index.php" class="inline-block bg-blue-600 hover:bg-blue-700 text-white font-bold px-8 py-3 rounded-lg">
                        الذهاب إلى لوحة التحكم
                    </a>

                    <div class="mt-8 p-4 bg-yellow-50 border border-yellow-200 rounded-lg text-right text-sm">
                        <p class="font-bold text-yellow-900 mb-2">⚠️ تنبيه أمني</p>
                        <p class="text-yellow-800">يُنصح بحذف أو تعطيل ملف <code class="bg-white px-2 py-1 rounded">install.php</code> بعد اكتمال التثبيت</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

</body>
</html>
