<?php
/**
 * منشئ الصفحات
 * Page Builder
 */

define('APP_PATH', __DIR__);
require_once APP_PATH . '/config/config.php';
require_once APP_PATH . '/config/database.php';
require_once APP_PATH . '/includes/functions.php';
require_once APP_PATH . '/auth/session.php';

requireLogin();

$templateId = $_GET['template'] ?? $_GET['id'] ?? null;
$projectId = $_GET['id'] ?? null;
$project = null;

// إذا كان هناك project ID، جلب المشروع
if ($projectId) {
    $user = getCurrentUser();
    $sql = "SELECT * FROM projects WHERE id = :id AND user_id = :user_id";
    $project = fetchOne($sql, ['id' => $projectId, 'user_id' => $user['id']]);
    
    if ($project) {
        $templateId = $project['template_id'];
        $project['data'] = json_decode($project['data'], true);
    }
}

// قوالب النماذج (نفس البيانات من dashboard.js)
$templatesData = json_encode([
    'landscaping' => [
        'name' => 'تنسيق حدائق',
        'fields' => ['companyName', 'phone', 'whatsapp', 'primaryColor', 'heroTitle', 'heroDescription']
    ],
    'moving' => [
        'name' => 'نقل عفش',
        'fields' => ['companyName', 'phone', 'whatsapp', 'primaryColor', 'heroTitle', 'heroDescription']
    ],
    'used-furniture' => [
        'name' => 'شراء اثاث مستعمل',
        'fields' => ['companyName', 'phone', 'whatsapp', 'primaryColor', 'heroTitle', 'heroDescription']
    ],
    'contracting' => [
        'name' => 'مقاولات عامة',
        'fields' => ['companyName', 'phone', 'whatsapp', 'primaryColor', 'heroTitle', 'heroDescription']
    ],
    'recruitment' => [
        'name' => 'استقدام عمالة',
        'fields' => ['companyName', 'phone', 'whatsapp', 'primaryColor', 'heroTitle', 'heroDescription']
    ],
    'decor' => [
        'name' => 'ديكور وتصميم داخلي',
        'fields' => ['companyName', 'phone', 'whatsapp', 'heroTitle', 'heroDescription']
    ],
    'pest-control' => [
        'name' => 'رش حشرات',
        'fields' => ['companyName', 'phone', 'whatsapp', 'primaryColor', 'heroTitle', 'heroDescription']
    ]
]);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?> - منشئ الصفحات</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap');
        body { font-family: 'Cairo', sans-serif; }
    </style>
</head>
<body class="bg-gray-50">

<div class="min-h-screen">
    <!-- Header -->
    <header class="bg-white border-b border-gray-200 sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 py-4 flex justify-between items-center">
            <div class="flex items-center gap-4">
                <a href="<?php echo SITE_URL; ?>" class="text-gray-600 hover:text-gray-900">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                </a>
                <h1 class="text-xl font-bold text-gray-900">
                    <?php echo $project ? 'تعديل: ' . htmlspecialchars($project['name']) : 'إنشاء صفحة جديدة'; ?>
                </h1>
            </div>
            <div class="flex gap-3">
                <button onclick="previewPage()" class="px-4 py-2 text-gray-700 bg-gray-100 hover:bg-gray-200 rounded-lg font-medium">معاينة</button>
                <button onclick="saveProject()" class="px-6 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-bold">حفظ</button>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <div class="max-w-7xl mx-auto px-4 py-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Form Section -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <h2 class="text-lg font-bold text-gray-900 mb-6">إعدادات الصفحة</h2>
                
                <form id="builder-form" class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">اسم المشروع *</label>
                        <input type="text" id="projectName" name="projectName" value="<?php echo $project ? htmlspecialchars($project['name']) : ''; ?>" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">اسم الشركة *</label>
                        <input type="text" id="companyName" name="companyName" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">رقم الهاتف *</label>
                        <input type="tel" id="phone" name="phone" placeholder="05xxxxxxxx" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">رقم الواتساب *</label>
                        <input type="tel" id="whatsapp" name="whatsapp" placeholder="05xxxxxxxx" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">اللون الرئيسي</label>
                        <input type="color" id="primaryColor" name="primaryColor" value="#3b82f6" class="w-full h-12 px-2 border border-gray-300 rounded-lg cursor-pointer">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">العنوان الرئيسي</label>
                        <input type="text" id="heroTitle" name="heroTitle" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">الوصف</label>
                        <textarea id="heroDescription" name="heroDescription" rows="3" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"></textarea>
                    </div>
                </form>
            </div>

            <!-- Preview Section -->
            <div class="bg-white p-6 rounded-xl border border-gray-200 shadow-sm">
                <h2 class="text-lg font-bold text-gray-900 mb-6">معاينة</h2>
                <div id="preview" class="border border-gray-200 rounded-lg p-8 min-h-[400px] bg-gray-50">
                    <div class="text-center text-gray-500">
                        <p>املأ النموذج لرؤية المعاينة</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
const SITE_URL = '<?php echo SITE_URL; ?>';
const TEMPLATE_ID = '<?php echo $templateId; ?>';
const PROJECT_ID = <?php echo $projectId ? $projectId : 'null'; ?>;
const PROJECT_DATA = <?php echo $project ? json_encode($project['data']) : 'null'; ?>;

// تحميل البيانات إذا كان مشروع موجود
if (PROJECT_DATA) {
    Object.keys(PROJECT_DATA).forEach(key => {
        const input = document.getElementById(key);
        if (input) {
            input.value = PROJECT_DATA[key];
        }
    });
}

// حفظ المشروع
async function saveProject() {
    const formData = new FormData(document.getElementById('builder-form'));
    const data = {};
    formData.forEach((value, key) => {
        data[key] = value;
    });

    if (!data.projectName || !data.companyName || !data.phone) {
        alert('يرجى تعبئة جميع الحقول المطلوبة');
        return;
    }

    const payload = {
        action: PROJECT_ID ? 'update' : 'create',
        template_id: TEMPLATE_ID,
        name: data.projectName,
        data: JSON.stringify(data)
    };

    if (PROJECT_ID) {
        payload.id = PROJECT_ID;
    }

    try {
        const response = await fetch(SITE_URL + '/api/projects.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams(payload)
        });

        const result = await response.json();

        if (result.success) {
            alert('تم حفظ المشروع بنجاح!');
            window.location.href = SITE_URL + '/index.php';
        } else {
            alert('حدث خطأ: ' + result.error);
        }
    } catch (error) {
        console.error('Error:', error);
        alert('حدث خطأ في الحفظ');
    }
}

// معاينة الصفحة
function previewPage() {
    const formData = new FormData(document.getElementById('builder-form'));
    const preview = document.getElementById('preview');
    
    const companyName = formData.get('companyName') || 'اسم الشركة';
    const heroTitle = formData.get('heroTitle') || 'عنوان الصفحة';
    const heroDescription = formData.get('heroDescription') || 'وصف الصفحة';
    const primaryColor = formData.get('primaryColor') || '#3b82f6';
    
    preview.innerHTML = `
        <div style="background: linear-gradient(135deg, ${primaryColor} 0%, ${primaryColor}ee 100%);" class="p-8 rounded-lg text-white">
            <h1 class="text-3xl font-bold mb-4">${companyName}</h1>
            <h2 class="text-2xl mb-3">${heroTitle}</h2>
            <p class="text-white/90">${heroDescription}</p>
        </div>
    `;
}

// تحديث المعاينة عند تغيير المدخلات
document.getElementById('builder-form').addEventListener('input', previewPage);

// معاينة أولية
setTimeout(previewPage, 100);
</script>

</body>
</html>
