<?php
/**
 * API التحليلات والإحصائيات
 * Analytics API
 */

define('APP_PATH', dirname(__DIR__));
require_once APP_PATH . '/config/config.php';
require_once APP_PATH . '/config/database.php';
require_once APP_PATH . '/includes/functions.php';
require_once APP_PATH . '/auth/session.php';

header('Content-Type: application/json; charset=utf-8');

$action = $_GET['action'] ?? '';

switch ($action) {
    case 'track_view':
        trackView();
        break;
    
    case 'stats':
        getStats();
        break;
    
    default:
        error('إجراء غير صحيح');
}

/**
 * تتبع زيارة
 */
function trackView() {
    $projectId = $_POST['project_id'] ?? $_GET['project_id'] ?? null;
    
    if (!$projectId) {
        error('يجب تحديد ID المشروع');
    }
    
    // زيادة عداد الزيارات
    $db = getDB();
    $sql = "UPDATE projects SET views = views + 1 WHERE id = :id";
    $stmt = $db->prepare($sql);
    $result = $stmt->execute(['id' => $projectId]);
    
    if ($result) {
        // جلب العدد الجديد
        $project = fetchOne("SELECT views FROM projects WHERE id = :id", ['id' => $projectId]);
        success('تم تسجيل الزيارة', ['views' => $project['views'] ?? 0]);
    } else {
        error('فشل تسجيل الزيارة');
    }
}

/**
 * الحصول على الإحصائيات
 */
function getStats() {
    requireLogin();
    
    $user = getCurrentUser();
    
    // إجمالي المشاريع
    $totalProjects = count('projects', 'user_id = :user_id', ['user_id' => $user['id']]);
    
    // إجمالي الزيارات
    $sql = "SELECT COALESCE(SUM(views), 0) as total_views FROM projects WHERE user_id = :user_id";
    $result = fetchOne($sql, ['user_id' => $user['id']]);
    $totalViews = $result['total_views'] ?? 0;
    
    // عدد النماذج المتاحة
    $totalTemplates = 7;
    
    // آخر المشاريع
    $sql = "SELECT id, name, template_id, views, created_at 
            FROM projects 
            WHERE user_id = :user_id 
            ORDER BY created_at DESC 
            LIMIT 5";
    $recentProjects = fetchAll($sql, ['user_id' => $user['id']]);
    
    $stats = [
        'total_projects' => $totalProjects,
        'total_views' => $totalViews,
        'total_templates' => $totalTemplates,
        'recent_projects' => $recentProjects
    ];
    
    success('تم جلب الإحصائيات بنجاح', $stats);
}
